// Permet de passer à la page principale
let button = document.getElementById("button-a");
let frame = document.getElementById("iframeA");
frame.classList.remove("fadeOut");

button.addEventListener("click", function () {
    let frameA = document.getElementById("iframeA");

    // Vérifie que l'iframe peut être manipulée
    try {
        let iframeDocument = frameA.querySelector("iframe").contentDocument || frameA.querySelector("iframe").contentWindow.document;
        
        let videos = iframeDocument.querySelectorAll("video");
        videos.forEach(video => {
            video.pause();
            video.style.pointerEvents = "none";
        });
    } catch (e) {
        console.error("Impossible d'accéder au contenu de l'iframe :", e);
    }

    // Ajouter l'animation de disparition
    frameA.classList.add("fadeOut");
    setTimeout(function () {
        frameA.style.zIndex = "-1"; // Cacher le contenu après l'animation
    }, 1000);
});
