<?php
session_start();

$host = 'localhost';
$dbname = 'starship_showdown';
$username = 'root';
$password = '';

// Connexion à la base de données (utilisez les mêmes paramètres que dans inscription.php)
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erreur de connexion à la base de données : " . $e->getMessage());
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login = $_POST['login'];
    $mot_de_passe = $_POST['mot_de_passe'];

    // Récupérer l'utilisateur par son login
    $stmt = $pdo->prepare("SELECT * FROM utilisateurs WHERE login = ?");
    $stmt->execute([$login]);
    $utilisateur = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($utilisateur && password_verify($mot_de_passe, $utilisateur['mot_de_passe'])) {
        // Connexion réussie : enregistrer l'utilisateur en session
        $_SESSION['login'] = $utilisateur['login'];
        echo "Connexion réussie ! Bienvenue, " . htmlspecialchars($utilisateur['login']) . ".";

        $_SESSION['login'] = $login;
        
        header("Location: ../accueil.php");
    } else {
        echo "<div class='invalid'>Login ou mot de passe incorrect.</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Connexion</title>
    <link rel="stylesheet" href="../css/style.css">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Albert+Sans:ital,wght@0,100..900;1,100..900&family=DM+Serif+Text:ital@0;1&family=Geist+Mono:wght@100..900&family=Hanken+Grotesk:ital,wght@0,100..900;1,100..900&family=Source+Serif+4:ital,opsz,wght@0,8..60,200..900;1,8..60,200..900&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=DM+Serif+Text:ital@0;1&family=Geist+Mono:wght@100..900&family=Hanken+Grotesk:ital,wght@0,100..900;1,100..900&family=Source+Serif+4:ital,opsz,wght@0,8..60,200..900;1,8..60,200..900&display=swap" rel="stylesheet">
</head>
<body>
    <div class="no-responsive"></div>
    <div class="bar"></div>
    <div class="wrapper4">
        <div class="logo">
            <img src="../assets/logo.svg" alt="">
            <p>Un “JRPG” web amateur codé en 3 jours,<br>et designé en 4 jours.<br> 
            2025 - développé par zaza. </p>
        </div>

        <div class="form">
            <p class="section-title albert-sans right">CONNEXION</p>
            <form method="POST" action="connexion.php">
                <div class="logins">
                    <div class="login">
                        <label for="login">Nom d'utilisateur</label>
                        <input type="text" name="login" required>
                    </div>
                    <div class="login">
                        <label for="mot_de_passe">Mot de passe</label>
                        <input type="password" name="mot_de_passe" required>
                    </div>
                </div>
                <div class="validation">
                    <button type="submit" class="btn-default">Se connecter</button>
                    <a href="inscription.php" class="btn-default">S'inscrire</a>
                </div>
            </form>
        </div>

    </div>
</body>
</html>
