<?php
include_once "operateur.php";

$response = "";

class Vaisseau {

    public $id;
    public $name;
    public $pv;
    public $mana;
    public $atk;
    public $def;
    public $equipage = [];
    public $statuses = []; 

    public function __construct($id, $name, $pv, $mana, $atk, $def, $equipage = []) {
        $this->id = $id;
        $this->name = $name;
        $this->pv = $pv;
        $this->mana = $mana;
        $this->atk = $atk;
        $this->def = $def;
        $this->equipage = $equipage;
    }

    public function showVaisseau() {
        // Vérifie si le tableau $this->statuses n'est pas vide
        $statuts = !empty($this->statuses) ? "<p style='color: purple;'>" . implode("<br>", $this->statuses) . "</p>" : "";
    
        return "<div class='vaisseau'>
                    <p class='albert-sans'><strong>{$this->name}</strong></p>
                    <p class='pv albert-sans'>{$this->pv} PV</p>
                    <p class='pt albert-sans'>{$this->mana} PT</p>
                    <p>{$statuts}</p>
                </div>";
    }

    public function showVaisseauHangar() {
        // Vérifie si le tableau $this->statuses n'est pas vide
        $statuts = !empty($this->statuses) ? "<p style='color: purple;'>" . implode("<br>", $this->statuses) . "</p>" : "";
    
        return "<div class='vaisseau-hangar'>
                    <p class='hanken-big'><strong>{$this->name}</strong></p>
                    <div class='donnees'> 
                        <div class='donnees1'> 
                            <p class='pv albert-sans'>{$this->pv} PV</p>
                            <p class='pt albert-sans'>{$this->mana} PT</p>
                        </div>
                        <div class='stats'>
                            <p class='albert-sans atk'>atk {$this->atk}</p>
                            <p class='albert-sans def'>def {$this->def}</p>
                        </div>
                    </div>
                </div>";
    }

    public function showVaisseauAccueil() {
        return "<div class='vaisseau-accueil'>
                    <div class='vaisseau-accueil-intro'>
                        <p class='hanken-xl'>{$this->name}</p>
                        <div class='stats'>
                            <p class='albert-sans'>atk {$this->atk}</p>
                            <p class='albert-sans'>def {$this->def}</p>
                        </div>
                    </div>
                    <div class='vaisseau-accueil-stats'> 
                        <p class='albert-sans'>{$this->pv} PV</p>
                        <p class='albert-sans'>{$this->mana} PT</p>
                    </div>
                </div>";
    }

    public function showStats() {
        return "<div class='stats'><p>
                Attaque - {$this->atk} <br>
                Défense - {$this->def}
                </p></div>";
    }

    public function showMoveset() {
        echo "<div class='moveset'>";
        foreach ($this->equipage as $operateur) {
            echo $operateur->showMove();
        }
        echo "</div>";
    }

    public function movesList() {
        echo "<div class='moves-list'>";
        foreach ($this->equipage as $operateur) {
            echo "<button class='btn-attaque albert-sans move' data-id='{$operateur->id}'>
                    {$operateur->name} - {$operateur->mana_cost} PT
                  </button>";
        }
        echo "</div>";
    }

    // Méthode qui applique un effet de statut à ce vaisseau
    public function applyStatus($status) {
        $this->statuses[] = $status;
        echo "<p>{$this->name} est maintenant {$status}.</p>";
    }

    // Méthode pour utiliser un mouvement et appliquer un statut
    public function useMove($operateur, $opp) {
        if (!($operateur instanceof Operateur)) {
            return "<p>Erreur : L'opérateur fourni n'est pas valide.</p>";
        }
    
        if ($this->mana < $operateur->mana_cost) {
            return "<p style='color: red;'>{$this->name} n'a pas assez de mana pour utiliser l'attaque {$operateur->name} !</p>";
        }
    
        $message = "<p>{$this->name} utilise <strong><em>{$operateur->name}</em></strong> sur <strong>{$opp->name} !</strong><br>";
    
        // Vérifie si le vaisseau est corrompu
        if (in_array('Corrompu', $this->statuses)) {
            // Si corrompu, 50 % de chances d'attaquer soi-même
            if (rand(0, 1) === 0) {
                $opp = $this; // Redirige l'attaque vers lui-même
                $message .= "<span style='color: purple;'>Mais {$this->name} est <em>corrompu</em> et se frappe lui-même au lieu de son adversaire !</span><br>";
            }
        }

        if (in_array('Délabré', $this->statuses)) {
            if ($this->pv > 0) {
                $damage = floor($this->pv / 10);
                $this->pv -= $damage; 
                $message .= "<span style='color: purple;'>{$this->name} se <em>délabre</em> à petit feu.  <strong> Il perd {$damage} PV</strong>.</span><br>";
            }
        }
 
    
        // Calcul des dégâts si l'attaque est valide
        if ($operateur->dmg > 0) {
            $totaldmg = $operateur->dmg * ($this->atk / 50) * (1 - ($opp->def / (80 + $opp->def))) + rand(1, 4);
            $totaldmg = round($totaldmg);
    
            // Applique les dégâts
            $opp->pv -= $totaldmg;
            $this->mana -= $operateur->mana_cost;
    
            $message .= "<span style='color: red;'><strong>{$opp->name} perd {$totaldmg} PV.</strong></span></p>";
        } else {
            // Si pas de dégâts, simplement consommer le mana
            $this->mana -= $operateur->mana_cost;
        }
    
        // Applique les effets si présents
        if (!empty($operateur->effects)) {
            foreach ($operateur->effects as $effect) {
                // Applique l'effet de statut (par exemple Corruption)
                $operateur->applyEffects($opp);
                $message .= "<p style='color: blue;'>{$opp->name} subit l'effet {$effect} !</p>";
            }
        }

        return $message;
    }


}
?>
