<?php
session_start();

$host = 'localhost';
$dbname = 'starship_showdown';
$username = 'root';
$password = '';

// Connexion à la base de données (utilisez les mêmes paramètres que dans inscription.php)
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erreur de connexion à la base de données : " . $e->getMessage());
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login = $_POST['login'];
    $mot_de_passe = $_POST['mot_de_passe'];

    // Récupérer l'utilisateur par son login
    $stmt = $pdo->prepare("SELECT * FROM utilisateurs WHERE login = ?");
    $stmt->execute([$login]);
    $utilisateur = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($utilisateur && password_verify($mot_de_passe, $utilisateur['mot_de_passe'])) {
        // Connexion réussie : enregistrer l'utilisateur en session
        $_SESSION['login'] = $utilisateur['login'];
        echo "Connexion réussie ! Bienvenue, " . htmlspecialchars($utilisateur['login']) . ".";

        $_SESSION['login'] = $login;
        
        header("Location: ../accueil.php");
    } else {
        echo "Login ou mot de passe incorrect.";
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Connexion</title>
    <link rel="stylesheet" href="../css/style.css">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Albert+Sans:ital,wght@0,100..900;1,100..900&family=DM+Serif+Text:ital@0;1&family=Geist+Mono:wght@100..900&family=Hanken+Grotesk:ital,wght@0,100..900;1,100..900&family=Source+Serif+4:ital,opsz,wght@0,8..60,200..900;1,8..60,200..900&display=swap" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=DM+Serif+Text:ital@0;1&family=Geist+Mono:wght@100..900&family=Hanken+Grotesk:ital,wght@0,100..900;1,100..900&family=Source+Serif+4:ital,opsz,wght@0,8..60,200..900;1,8..60,200..900&display=swap" rel="stylesheet">
</head>
<body>
    <div class="wrapper4">
        <h1>Connexion</h1>
        <form method="POST" action="connexion.php">
            <div class="login">
                <label for="login">Login :</label>
                <input type="text" name="login" required>
            </div>
            <div class="mdp">
                <label for="mot_de_passe">Mot de passe :</label>
                <input type="password" name="mot_de_passe" required>
            </div>
            <button type="submit" class="btn-normal">Se connecter</button>
        </form>
        <a href="inscription.php">S'inscrire</a>
    </div>
</body>
</html>
