<?php
header('Content-Type: application/json');

// Informations de connexion
$servername = "localhost";
$username = "root";
$password = ""; 
$dbname = "dataviz";

try {
    // Connexion à la base de données
    $conn = new mysqli($servername, $username, $password, $dbname);

    // Vérification de la connexion
    if ($conn->connect_error) {
        throw new Exception("Connection failed: " . $conn->connect_error);
    }

    // Requête SQL
    $sql = "SELECT * FROM final_dataset";
    $result = $conn->query($sql);

    if (!$result) {
        throw new Exception("Error in query: " . $conn->error);
    }

    // Initialiser un tableau pour les genres et les langues uniques
    $allGenres = [];
    $allLanguages = [];

    // Préparation des données
    $data = [];
    while ($row = $result->fetch_assoc()) {
        $cleanedRow = [
            "id" => $row["id"] ?? null,
            "title" => $row["title"] ?? null,
            "movie_link" => $row["movie_link"] ?? null,
            "year" => isset($row["year"]) ? (int)$row["year"] : null,
            "duration" => $row["duration"] ?? null,
            "mpa" => $row["mpa"] ?? null,
            "rating" => isset($row["rating"]) ? (float)$row["rating"] : null,
            "votes" => isset($row["votes"]) ? (int)str_replace("K", "000", $row["votes"]) : null,
            "budget" => isset($row["budget"]) ? (float)$row["budget"] : null,
            "gross_worldwide" => isset($row["gross_worldwide"]) ? (float)$row["gross_worldwide"] : null,
            "gross_us_canada" => isset($row["gross_us_canada"]) ? (float)$row["gross_us_canada"] : null,
            "opening_weekend_gross" => isset($row["opening_weekend_gross"]) ? (float)$row["opening_weekend_gross"] : null,
            "directors" => isset($row["directors"]) ? json_decode(str_replace("'", '"', $row["directors"])) : [],
            "writers" => isset($row["writers"]) ? json_decode(str_replace("'", '"', $row["writers"])) : [],
            "stars" => isset($row["stars"]) ? json_decode(str_replace("'", '"', $row["stars"])) : [],
            "genres" => isset($row["genres"]) ? json_decode(str_replace("'", '"', $row["genres"])) : [],
            "countries_origin" => isset($row["countries_origin"]) ? json_decode(str_replace("'", '"', $row["countries_origin"])) : [],
            "filming_locations" => isset($row["filming_locations"]) ? json_decode(str_replace("'", '"', $row["filming_locations"])) : [],
            "production_companies" => isset($row["production_companies"]) ? json_decode(str_replace("'", '"', $row["production_companies"])) : [],
            "languages" => isset($row["languages"]) ? json_decode(str_replace("'", '"', $row["languages"])) : [],
            "wins" => isset($row["wins"]) ? (int)$row["wins"] : null,
            "nominations" => isset($row["nominations"]) ? (int)$row["nominations"] : null,
            "oscars" => isset($row["oscars"]) ? (int)$row["oscars"] : null,
        ];

        // Ajouter les genres de ce film au tableau des genres
        if (isset($row["genres"]) && $row["genres"] != null) {
            $genres = json_decode(str_replace("'", '"', $row["genres"]));
            foreach ($genres as $genre) {
                // Ajouter les genres au tableau des genres uniques
                if (!in_array($genre, $allGenres)) {
                    $allGenres[] = $genre;
                }
            }
        }

        // Ajouter les langues de ce film au tableau des langues
        if (isset($row["languages"]) && $row["languages"] != null) {
            $languages = json_decode(str_replace("'", '"', $row["languages"]));
            foreach ($languages as $language) {
                // Ajouter les langues au tableau des langues uniques
                if (!in_array($language, $allLanguages)) {
                    $allLanguages[] = $language;
                }
            }
        }

        $data[] = $cleanedRow;
    }

    // Fermeture de la connexion
    $conn->close();

    // Préparer les résultats JSON
    $response = [
        'movies' => $data,  // Contient toutes les données des films
        'genres' => $allGenres,  // Contient tous les genres uniques
        'languages' => $allLanguages,  // Contient toutes les langues uniques
    ];

    // Envoi des données JSON
    echo json_encode($response, JSON_PRETTY_PRINT);

} catch (Exception $e) {
    // Gestion des erreurs
    http_response_code(500);
    echo json_encode(["error" => $e->getMessage()]);
}
?>
