<?php
  session_start();

  //Redirection si pas connecté
  if (!isset($_SESSION['admin_user'])) {
    header("Location: admin.php"); 
    exit();
  }

  //Connexion à la base de données
  $conn = new mysqli("localhost", "marwan_trc", "pokemonepee1511", "marwan_resa_manga");

  //On récupère les id de chaque genre sur la table genre pour l'inclure au formulaire d'insertion
  $sql_genre = "SELECT * FROM genre";
  $select_genre = $conn->query($sql_genre);

  //On récupère directement les données liées aux mangas
  $sql = "SELECT manga.id_manga, manga.titre, manga.auteur, manga.nb_exemplaires, manga.cover, genre.nom_genre
          FROM manga
          JOIN genre ON manga.id_genre = genre.id_genre
          ORDER BY manga.cover DESC, manga.id_manga;";
  $select_manga = $conn->query($sql);

  //On récupère les données des mangas qui collent à la recherche si jamais on appuye sur le bouton recherche
  if(isset($_POST['search'])){

    $search = $_POST['search'];
    $search_text = '%'.$search.'%';

    $search_manga = $conn->prepare("SELECT manga.id_manga, manga.titre, manga.auteur, manga.nb_exemplaires, manga.cover, genre.nom_genre
    FROM manga
    JOIN genre ON manga.id_genre = genre.id_genre
    WHERE manga.titre LIKE ?
    OR manga.auteur LIKE ?
    OR genre.nom_genre LIKE ?
    ORDER BY manga.cover DESC, manga.id_manga;");
    $search_manga->bind_param('sss', $search_text, $search_text, $search_text);
    $search_manga->execute();
    $result_search = $search_manga->get_result();

    $conn->close();

  }
  

  if (isset($_POST['inserer'])) {
    $titre = $_POST['titre'];
    $auteur = $_POST['auteur'];
    $id_genre = $_POST['id_genre'];
    $nb_exemplaires = $_POST['nb_exemplaires'];
  
    // On stocke les différentes variables FILES dans des variables normales pour faciliter la lisibilité du code
    if (isset($_FILES['cover']) && $_FILES['cover']['error'] == 0) {

      

      $valide = ['jpg', 'jpeg', 'png']; 
      $nom_fichier = $_FILES['cover']['name']; 
      $taille_fichier = $_FILES['cover']['size']; 
      $temp = $_FILES['cover']['tmp_name']; 
      $ext = strtolower(pathinfo($nom_fichier, PATHINFO_EXTENSION)); 
  
      if (in_array($ext, $valide)) {
        if ($taille_fichier < 5000000) { // 5 MB
          $path = 'images/' . basename($nom_fichier); 
          if (move_uploaded_file($temp, $path)) {
            $cover = $path; 
          } 
        }
      } 
    }
  
    // On intègre toutes les données dans la base de données
    $insert_manga = $conn->prepare("INSERT into manga(titre, auteur, id_genre, nb_exemplaires, cover) VALUES(?, ?, ?, ?, ?);");
    $insert_manga->bind_param('ssiis', $titre, $auteur, $id_genre, $nb_exemplaires, $cover);
    $insert_manga->execute();
  
    header("Location: homepage_admin.php");
    $conn->close();
  }


  if (isset($_POST['modifier'])) {
    $id_manga = $_POST['id_manga'];
    $titre = $_POST['titre'];
    $auteur = $_POST['auteur'];
    $id_genre = $_POST['id_genre'];
    $nb_exemplaires = $_POST['nb_exemplaires'];
    $cover = $_POST['existing_cover'];

    if (isset($_FILES['cover']) && $_FILES['cover']['error'] == 0) {
      $valide = ['jpg', 'jpeg', 'png'];
      $nom_fichier = $_FILES['cover']['name'];
      $taille_fichier = $_FILES['cover']['size'];
      $temp = $_FILES['cover']['tmp_name'];
      $ext = strtolower(pathinfo($nom_fichier, PATHINFO_EXTENSION));
  
      if (in_array($ext, $valide)) {
        if ($taille_fichier < 5000000) { // 5 MB
          $path = 'images/' . basename($nom_fichier);
          if (move_uploaded_file($temp, $path)) {
            // Supprimer l'ancienne couverture du serveur si elle existe et n'est pas la couverture par défaut
            if ($cover !== $_POST['existing_cover'] && file_exists($_POST['existing_cover'])) {
              unlink($_POST['existing_cover']);
            }
            $cover = $path;
          } 
        } 
      } 
    }
  
    // Mise à jour des données du manga dans la base de données
    $update_manga = $conn->prepare("UPDATE manga SET titre = ?, auteur = ?, id_genre = ?, nb_exemplaires = ?, cover = ? WHERE id_manga = ?");
    $update_manga->bind_param('ssiisi', $titre, $auteur, $id_genre, $nb_exemplaires, $cover, $id_manga);
    $update_manga->execute();
  
    // Redirection après mise à jour
    header("Location: homepage_admin.php");
    $conn->close();
  }





?>


<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="main.css">
  <title>Espace Admin - Plume</title>
</head>
<body>

  <header>
    <h1>Plume - Backoffice</h1>
    <nav>
      <a href="homepage_admin.php">Mangas</a>
      <a href="clients.php">Clients</a>
      <a href="tableaubord.php">Tableau de bord</a>
      <a href="deconnexion.php" class="deco">Déconnexion</a>
      <p>AdminVanier</p>
    </nav>
  </header>

  <main>
    <div class="titles">
    <h2 class="page-title-insert">Insérer un manga</h2>
    </div>
    
    <div class="insert-forms">


      <form action="" class="insert-manga-form" method="post" enctype="multipart/form-data">

        <fieldset>
          <label for="titre">Titre <em>(Titre du manga - n° de tome)</em></label>
          <input type="text" name="titre" id="titre" required>
        </fieldset>

        <fieldset>
          <label for="auteur">Auteur <em>(Prénom et nom)</em></label>
          <input type="text" name="auteur" id="auteur" required>
        </fieldset>

        <fieldset>
          <label for="nb_exemplaires">Exemplaires en stock</label>
          <input type="number" min="0" name="nb_exemplaires" id="nb_exemplaires" required>
        </fieldset>

        <fieldset>
          <label for="id_genre">Genre</label>
          <select name="id_genre" id="id_genre">
            <?php
              if($select_genre->num_rows > 0){
                while($genre_col = $select_genre->fetch_assoc()){
                  echo "<option value='".$genre_col['id_genre']."'>
                          ".$genre_col['nom_genre'].
                        "</option>";
                }
              }

            ?>
          </select>
        </fieldset>

        <fieldset>
        <label for="cover">Couverture <em>(jpg, png ou webp - 5MB max.)</em></label>
        <input type="file" name="cover" id="cover" accept="image/jpeg, image/png, image/jpeg" required>
        </fieldset>
        

        <input type="submit" class="insert-manga-form-submit" name="inserer" value="Ajouter">
      </form>


    </div>
    
    <div class="search">
      <h2 class="page-title-list">Liste des mangas</h2>
      <p class="bug">Bug - Impossible de modifier la couverture du premier manga qui s'affiche sur la page. 
        J'ai abandonné après avoir passé plus de deux heures à essayer de résoudre le problème..</p>
      <form action="" method="post">
        <input type="search" name="search" placeholder="Recherchez vos mangas ici...">
      </form>

    </div>
    
    <form action="" class="manga-back-form" method="post">

      <div class="manga-list-back">
        <?php //On affiche les mangas dans un format de tuiles
          if(isset($_POST['search'])){
            if($result_search->num_rows > 0){
              while($col = $result_search->fetch_assoc()){
                echo "<div class='manga-card'>";
                echo "  <div class='manga-card-header'>";
                echo "  <p class='manga-card-id'>".$col['id_manga']."</p>";
                echo "  <p class='manga-card-name'>".$col['titre']."</p>";
                echo "  <p class='manga-card-author'>".$col['auteur']."</p>";
                echo "  </div>";
                echo "  <img src='".$col['cover']."' width = 100% class='manga-card-cover'>";

                echo "  <p class='manga-card-genre'>".$col['nom_genre']."</p>";
                echo "  <p class='manga-card-stock'>En stock : ".$col['nb_exemplaires']."</p>";
  
                //On crée un formulaire pour chaque manga afin de le modifier selon notre bon vouloir
                echo "  <form action='' method='post' enctype='multipart/form-data' class='update-manga-form'>";
                echo "    <input type='hidden' name='id_manga' value='" . $col['id_manga'] . "'>";
                echo "    <fieldset><label for='titre'>Titre</label><input type='text' name='titre' value='" . $col['titre'] . "' required></fieldset>";
                echo "    <fieldset><label for='auteur'>Auteur</label><input type='text' name='auteur' value='" . $col['auteur'] . "' required></fieldset>";
                echo "    <fieldset><label for='nb_exemplaires'>Exemplaires en stock</label><input type='number' min='0' name='nb_exemplaires' value='" . $col['nb_exemplaires'] . "' required></fieldset>";
                echo "    <fieldset><label for='id_genre'>Genre</label><select name='id_genre'>";
                // Après avoir parcouru tout le tableau des genres une fois sur le formulaire précédent, faut remettre le "curseur" à zéro
                $select_genre->data_seek(0); 
                while ($genre_col = $select_genre->fetch_assoc()) {
                  echo "<option value='".$genre_col['id_genre']."'>
                  ".$genre_col['nom_genre'].
                  "</option>";
                }
                echo "    </select></fieldset>";
                echo "    <fieldset><label for='cover'>Couverture</label><input type='file' name='cover' accept='image/jpeg, image/png, image/jpeg'></fieldset>";
                echo "    <input type='hidden' name='existing_cover' value='" .$col['cover'] . "'>";
                echo "    <input type='submit' class='update-manga-form-submit' name='modifier' value='Modifier'>";
                echo "  </form>";
                echo "</div>";
              }
            }
          } else {
              if($select_manga->num_rows > 0){
                while($col = $select_manga->fetch_assoc()){
                  echo "<div class='manga-card'>";
                  echo "  <div class='manga-card-header'>";
                  echo "    <p class='manga-card-id'>".$col['id_manga']."</p>";
                  echo "    <div>";
                  echo "      <p class='manga-card-name'>".$col['titre']."</p>";
                  echo "      <p class='manga-card-author'>".$col['auteur']."</p>";
                  echo "    </div>";
                  echo "  </div>";
                  echo "  <img src='".$col['cover']."' width = 100% class='manga-card-cover'>";

                  echo "  <p class='manga-card-genre'>".$col['nom_genre']."</p>";
                  echo "  <p class='manga-card-stock'>En stock : ".$col['nb_exemplaires']."</p>";
    
                  //On crée un formulaire pour chaque manga afin de le modifier selon notre bon vouloir
                  echo "  <form action='' method='post' enctype='multipart/form-data' class='update-manga-form'>";
                  echo "    <input type='hidden' name='id_manga' value='" . $col['id_manga'] . "'>";
                  echo "    <fieldset><label for='titre'>Titre</label><input type='text' name='titre' value='" . $col['titre'] . "' required></fieldset>";
                  echo "    <fieldset><label for='auteur'>Auteur</label><input type='text' name='auteur' value='" . $col['auteur'] . "' required></fieldset>";
                  echo "    <fieldset><label for='nb_exemplaires'>Exemplaires en stock</label><input type='number' min='0' name='nb_exemplaires' value='" . $col['nb_exemplaires'] . "' required></fieldset>";
                  echo "    <fieldset><label for='id_genre'>Genre</label><select name='id_genre'>";
                  // Après avoir parcouru tout le tableau des genres une fois sur le formulaire précédent, faut remettre le "curseur" à zéro
                  $select_genre->data_seek(0); 
                  while ($genre_col = $select_genre->fetch_assoc()) {
                    $selected = $col['id_genre'] == $genre_col['id_genre'] ? "selected" : "";
                    echo "<option value='" . $genre_col['id_genre'] . "' $selected>" . $genre_col['nom_genre'] . "</option>";
                  }
                  echo "    </select></fieldset>";
                  echo "    <fieldset><label for='cover'>Couverture</label><input type='file' name='cover' accept='image/jpeg, image/png, image/jpeg'></fieldset>";
                  echo "    <input type='hidden' name='existing_cover' value='" .$col['cover'] . "'>";
                  echo "    <input type='submit' class='update-manga-form-submit' name='modifier' value='Modifier'>";
                  echo "  </form>";
                  echo "</div>";
                  
                }
              }
            } 
          
          
          
        ?>
      </div>
      
    </form>

  </main>

  
</body>
</html>