<?php
  session_start();
  
  //Redirection si pas connecté
  if (!isset($_SESSION['pseudo'])) {
    header("Location: connexion.php"); 
    exit();
}

  //Connexion à la base de données
  $conn = new mysqli("localhost", "marwan_trc", "pokemonepee1511", "marwan_resa_manga");

    //On récupère directement les données liées aux mangas en stock
  $sql = "SELECT manga.id_manga, manga.titre, manga.auteur, manga.nb_exemplaires, manga.cover, genre.nom_genre
          FROM manga
          JOIN genre ON manga.id_genre = genre.id_genre
          WHERE manga.nb_exemplaires > 0
          ORDER BY manga.cover DESC;";
  $select_manga = $conn->query($sql);

  $verify_resa = true;


  if(isset($_POST['reserver'])){

    
    $date_debut = $_POST['date_debut'];
    $date_fin = $_POST['date_fin'];



    if (isset($_POST['check_manga']) && !empty($_POST['check_manga'])) {

      //On insère dans la base de données la nouvelle réservation
      $insert_resa = $conn->prepare("INSERT into reservation(id_client, date_debut, date_fin, date_reservation) VALUES (?, ?, ?, NOW())");
      $insert_resa-> bind_param("sss", $_SESSION['id_client'], $date_debut, $date_fin);
      $insert_resa-> execute();
      $id_reservation = $conn->insert_id; //On récupère l'id de la nouvelle résa

      //On prépare les requêtes qui vont permettre de mettre à jour le stock de mangas et de lier les mangas à leur réservation
      $insert_liaison = $conn->prepare("INSERT into reservation_manga VALUES (?, ?);");
      $manga_stock = $conn->prepare("UPDATE manga SET nb_exemplaires = nb_exemplaires - 1 WHERE id_manga = ?;");

      foreach ($_POST['check_manga'] as $id_manga) {
          $insert_liaison->bind_param("ii", $id_reservation, $id_manga,);
          $insert_liaison->execute();

          $manga_stock->bind_param("i", $id_manga);
          $manga_stock->execute();
      }

      header("Location: reservations.php");

    } else {
      $verify_resa = false;
    }
  }
?>


<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="main.css">
  <title>Espace client - Plume</title>
</head>
<body>

  <header>
    <h1>Plume</h1>
    <nav>
      <a href="homepage_client.php">Réserver des mangas</a>
      <a href="reservations.php">Vos réservations</a>
      <a href="deconnexion.php" class="deco">Déconnexion</a>
      <p><?php echo $_SESSION['pseudo'];?> - Espace Client</p>
    </nav>
  </header>

  <main>
    <div class="page-title">
      <h2>Réserver des mangas</h2>
      <p>Cliquez sur les mangas que vous souhaitez réserver pour les sélectionner.</p>
    </div>
    

    <form action="" class="resa-form" method="post">

      <div class="manga-list">
        <?php //On affiche les mangas dans un format de tuiles
          if($select_manga->num_rows > 0){
            while($col = $select_manga->fetch_assoc()){
              echo "<div class='manga-card' id='manga-card'>";
              echo "  <p class='manga-card-name'>".$col['titre']."</p>";
              echo "  <img src='".$col['cover']."' width = 100% class='manga-card-cover'>";
              echo "  <p class='manga-card-author'>".$col['auteur']."</p>";
              echo "  <p class='manga-card-genre'>".$col['nom_genre']."</p>";
              echo "  <input type='checkbox' name='check_manga[]' class='check-manga' value='".$col['id_manga']." id='checkbox' required'>";
              echo "</div>";
            }
          }
        ?>
      </div>


      <div class="resa-choice">
        <label for="date_debut">Date de début d'emprunt</label>
        <input type="date" value="2024-05-31" min='2024-05-31' max="2024-08-31" class="date-debut" name="date_debut" id="date_debut" required>

        <label for="date_fin">Date de fin d'emprunt</label>
        <input value="2024-07-01" min='2024-07-01' max="2024-10-01" type="date" class="date-fin" name="date_fin" id="date_debut" required>

        <div class="resa-bouton">
            <input type="submit" name="reserver" value="Réserver">
          <?php
          if($verify_resa == false){
              echo "<p class='error-text'> Veuillez sélectionner au moins un manga !</p>";
          }

          ?>
        </div>




      </div>
    </form>

  </main>

  <div class="admin-link"><a href="admin.php">Espace<br>Administrateur</a></div>

  <script>
    document.addEventListener('DOMContentLoaded', function() {
      var manga_card = document.querySelectorAll('.manga-card');

      //Pour chaque carte, appuyer sr l'une d'entre elles coche ou décoche la checkbox
      manga_card.forEach(function(card) {
        card.addEventListener('click', function() {
          var checkbox = card.querySelector('.check-manga');
          checkbox.checked = !checkbox.checked;

          if (checkbox.checked) {
            card.classList.add('checked');
          } else {
            card.classList.remove('checked');
          }
        });
      });
    });
  </script>
  
</body>
</html>