let isDragging = false;

let animationFrameId;
let currentMouseX, currentMouseY;
let lastMouseX, lastMouseY;

let scrollSpeedFactor = 1.1;
let smoothFactor = 0.03;
let decelerationFactor = 0.93;

// Détection du navigateur
const userAgent = navigator.userAgent.toLowerCase();

// Fonction pour ajuster les facteurs en fonction du navigateur
function adjustScrollValuesForBrowser() {
    if (userAgent.indexOf('chrome') > -1) {
        // Pour Chrome, on peut garder les valeurs originales ou les ajuster
        scrollSpeedFactor = 1.1;
        smoothFactor = 0.05;
        decelerationFactor = 0.8;
    } else if (userAgent.indexOf('firefox') > -1) {
        // Pour Firefox, on peut réduire légèrement la vitesse pour une expérience plus fluide
        scrollSpeedFactor = 1.1;  // Vitesse plus faible pour Firefox
        smoothFactor = 0.03;       // Lissage un peu plus élevé
        decelerationFactor = 0.93;  // Moins de décélération
    } else if (userAgent.indexOf('safari') > -1) {
        // Pour Safari, ajuster pour tenir compte du comportement spécifique du défilement
        scrollSpeedFactor = 1.15;  // Vitesse un peu plus rapide
        smoothFactor = 0.02;       // Lissage plus faible
        decelerationFactor = 0.95; // Plus de décélération
    } else if (userAgent.indexOf('edge') > -1) {
        // Pour Edge, utiliser des valeurs proches de Chrome
        scrollSpeedFactor = 1.1;
        smoothFactor = 0.03;
        decelerationFactor = 0.93;
    } else {
        // Valeurs par défaut pour les autres navigateurs
        scrollSpeedFactor = 1.1;
        smoothFactor = 0.03;
        decelerationFactor = 0.93;
    }
}

// Appeler cette fonction pour ajuster les valeurs en fonction du navigateur
adjustScrollValuesForBrowser();

let scrollDeltaX = 0, scrollDeltaY = 0; // Delta de mouvement lissé

const content = document.documentElement || document.body; // Get the scrollable element
const maxX = content.scrollWidth - window.innerWidth; // Max horizontal scroll
const maxY = content.scrollHeight - window.innerHeight; // Max vertical scroll

// Début du drag
document.addEventListener('mousedown', (e) => {
    // Vérifie si l'élément cliqué est #loading-screen
    if (e.target.closest('#loading-screen')) {
        return; // Si c'est #loading-screen, on ne fait rien
    }

    isDragging = true;
    document.body.style.cursor = 'grabbing';

    lastMouseX = currentMouseX = e.clientX;
    lastMouseY = currentMouseY = e.clientY;

    document.addEventListener('mousemove', onMouseMove);

    animationFrameId = requestAnimationFrame(scrollPage);
});

// Capturer la position de la souris pendant le drag
function onMouseMove(e) {
    currentMouseX = e.clientX;
    currentMouseY = e.clientY;
}

// Mise à jour de la position de scroll avec effet fluide
function scrollPage() {
    if (!isDragging && Math.abs(scrollDeltaX) < 0.1 && Math.abs(scrollDeltaY) < 0.1) {
        cancelAnimationFrame(animationFrameId);
        return; // Arrête l'animation si le mouvement est presque nul
    }

    if (isDragging == true) {
        // Calcul du delta de mouvement
        const rawDeltaX = (lastMouseX - currentMouseX) * scrollSpeedFactor;
        const rawDeltaY = (lastMouseY - currentMouseY) * scrollSpeedFactor;

        // Appliquer un effet de lissage
        scrollDeltaX += (rawDeltaX - scrollDeltaX) * smoothFactor;
        scrollDeltaY += (rawDeltaY - scrollDeltaY) * smoothFactor;

        lastMouseX = currentMouseX;
        lastMouseY = currentMouseY;
    }

    if (isDragging == false) {
        scrollDeltaX *= decelerationFactor;
        scrollDeltaY *= decelerationFactor;
    }

    // Scroller la fenêtre
    window.scrollBy({
        left: scrollDeltaX,
        top: scrollDeltaY,
        behavior: 'auto' // Le lissage est manuel
    });

    // Continuer la boucle
    animationFrameId = requestAnimationFrame(scrollPage);
}

// Arrêter le drag
window.addEventListener('mouseup', () => {
    isDragging = false;
    document.body.style.cursor = 'grab';
});

// Arrêter le drag si la souris sort de la fenêtre
document.addEventListener('mouseleave', () => {
    isDragging = false;
    document.body.style.cursor = 'grab';
});
